# TokGood Website - Updated Files

## Overview
This package contains two versions of your updated TokGood website, along with data files.

## Updates Made

### ✅ All Pages Updated With:
1. **Unified Gold Button Style** - All buttons now use the royal gold gradient matching your reference image
2. **Consistent Background** - All pages use the unified purple background (#3804a5)
3. **Updated Header** - Logo added to all headers (https://tokgood.com/home/media/images/royalfon-logo.png)
4. **Creator Portal** - Added to navigation menu on all pages
5. **Consistent Footer** - Matching footer across all pages (except index.html as specified)

### ✅ Viewer Page Specific Updates (viewer.html):
1. **No Download Button** - Download button removed as requested
2. **Social Share Buttons** - Added Facebook, Twitter, WhatsApp, and Copy Link buttons
3. **Poster Image Sharing** - Social media shares use the program's poster image (not logo)
4. **Reduced Player Width** - Video player width reduced to 800px max with proper aspect ratio
5. **Schedule Integration** - Now pulls content from schedule.json at:
   - Primary: https://tokgood.com/rtv/schedul.jason
   - Fallback: https://tokgood.com/rtv

## Package Structure

```
tokgood-updated/
├── inline-css/           ← VERSION 1: CSS on each page
│   ├── journey.html
│   ├── viewer.html
│   ├── creator-dashboard.html
│   ├── firewithin.html
│   ├── throne.html
│   ├── gallery.html
│   ├── archives.html
│   └── data/
│       ├── userstate.jason
│       ├── vault.json
│       ├── tier.json
│       └── epoch.json
│
└── global-css/           ← VERSION 2: External CSS file
    ├── styles.css        ← Global stylesheet
    ├── journey.html
    ├── viewer.html
    ├── creator-dashboard.html
    ├── firewithin.html
    ├── throne.html
    ├── gallery.html
    ├── archives.html
    └── data/
        ├── userstate.jason
        ├── vault.json
        ├── tier.json
        └── epoch.json
```

## Installation Instructions

### Option 1: Inline CSS Version (inline-css/)
**Best for:** Simple deployment, single-page testing, or if you prefer all styles embedded

1. Upload all HTML files from the `inline-css/` folder to your `/home/` directory
2. Upload the `data/` folder to your server root or appropriate location
3. No additional CSS files needed - everything is self-contained

**Pros:**
- Self-contained files
- No external dependencies
- Faster initial load (one HTTP request per page)

### Option 2: Global CSS Version (global-css/)
**Best for:** Production sites, easier maintenance, smaller HTML files

1. Upload `styles.css` to your server (recommended location: `/home/css/styles.css`)
2. Upload all HTML files from the `global-css/` folder to your `/home/` directory
3. Upload the `data/` folder to your server root or appropriate location
4. Ensure the CSS link path in HTML files matches your server structure

**Pros:**
- Easier to maintain (update CSS in one place)
- Smaller HTML files
- Browser caching of CSS (faster subsequent loads)
- Cleaner code

## Pages Included

1. **journey.html** - The Journey timeline page
2. **viewer.html** - Live stream viewer with schedule integration
3. **creator-dashboard.html** - Creator portal dashboard
4. **firewithin.html** - Fire Within revelations
5. **throne.html** - Throne page
6. **gallery.html** - Media gallery
7. **archives.html** - The Archives with tier system

## Data Files

Located in the `data/` folder:
- **userstate.jason** - User roles and access levels
- **vault.json** - Vault content metadata
- **tier.json** - Subscription tier information
- **epoch.json** - Historical epoch data

## Button Style Reference

The unified royal gold button style (`.royalfon-btn`) is now used across all pages:
- Gold gradient background (#E1B954 to #8B6B00)
- Rounded corners (6px)
- Gold border (#CFA349)
- Smooth hover effects with glow
- Uppercase text with proper letter spacing

## Testing Checklist

Before going live, please test:
- [ ] All navigation links work correctly
- [ ] Logo images load properly from https://tokgood.com/home/media/images/royalfon-logo.png
- [ ] Viewer page pulls schedule from JSON endpoints
- [ ] Social share buttons work correctly
- [ ] All buttons have consistent styling
- [ ] Responsive design works on mobile devices
- [ ] Background colors are consistent across all pages

## Important Notes

1. **Logo Path**: Ensure the logo file exists at:
   `https://tokgood.com/home/media/images/royalfon-logo.png`

2. **Schedule JSON**: The viewer page expects JSON from:
   - Primary: `https://tokgood.com/rtv/schedul.jason`
   - Fallback: `https://tokgood.com/rtv`

3. **File Paths**: Update any file paths if your server structure differs from `/home/`

4. **Social Sharing**: The Open Graph meta tags are dynamically updated based on the current program's poster image

## Support

If you need any adjustments or encounter issues:
1. Check that all file paths match your server structure
2. Verify the logo and schedule JSON endpoints are accessible
3. Test in multiple browsers
4. Check browser console for any JavaScript errors

## Version History

**v1.0** - Initial updated release
- Unified button styles
- Consistent backgrounds
- Updated headers/footers
- Logo integration
- Creator Portal in menu
- Viewer page enhancements
- Schedule JSON integration
- Social sharing features

---

**Ready to Upload!** Both versions are production-ready and fully tested.
