# 🚀 QUICK START GUIDE

## Choose Your Version

### 📦 **Version 1: Inline CSS** (Recommended for beginners)
```
📁 Use: inline-css/ folder
✅ All styles are in each HTML file
✅ Just upload and go!
```

### 🎨 **Version 2: Global CSS** (Recommended for production)
```
📁 Use: global-css/ folder  
✅ One CSS file (styles.css) for all pages
✅ Easier to maintain and update
```

## 🎯 Installation (3 Steps)

### Step 1: Choose Your Version
Pick either `inline-css/` OR `global-css/` folder (not both)

### Step 2: Upload to Server
**For inline-css version:**
```
Upload all .html files → /home/ directory on server
Upload data/ folder → /home/data/ on server
```

**For global-css version:**
```
Upload styles.css → /home/css/styles.css on server
Upload all .html files → /home/ directory on server  
Upload data/ folder → /home/data/ on server
```

### Step 3: Test
Open any page in your browser and verify:
- ✅ Logo displays
- ✅ Buttons have gold gradient
- ✅ Navigation works
- ✅ Background is purple

## 📋 Complete File List

### HTML Pages (7 total):
- ✅ journey.html
- ✅ viewer.html
- ✅ creator-dashboard.html
- ✅ firewithin.html
- ✅ throne.html
- ✅ gallery.html
- ✅ archives.html

### Data Files (4 total):
- ✅ userstate.jason
- ✅ vault.json
- ✅ tier.json
- ✅ epoch.json

## 🔍 What Changed?

### All Pages:
- 🎨 Unified gold button style (matching your reference image)
- 🟣 Consistent purple background (#3804a5)
- 🖼️ Logo added to headers
- 🔗 "Creator Portal" in navigation
- 📱 Improved mobile responsiveness

### Viewer Page Special Updates:
- ❌ Download button removed
- 📤 Social share buttons added (Facebook, Twitter, WhatsApp)
- 🖼️ Program poster shows in social shares (not logo)
- 📺 Video player width optimized (no black bars)
- 📊 Schedule pulls from JSON: https://tokgood.com/rtv/schedul.jason

## ⚠️ Important URLs to Verify

Make sure these exist on your server:
1. **Logo**: https://tokgood.com/home/media/images/royalfon-logo.png
2. **Schedule JSON**: https://tokgood.com/rtv/schedul.jason

## 💡 Tips

- Start with inline-css version for testing
- Switch to global-css version for production
- Keep data files updated as your content grows
- Test on mobile devices after upload

## 📞 Need Help?

Check the README.md file for detailed documentation!

---
**✨ Your website is ready to upload! ✨**
